/*
 * Imports.h
 *
 *  Created on: Nov 19, 2013
 *      Author: nino
 */

#ifndef IMPORTS_H_
#define IMPORTS_H_



#include <StandardLibs.h>
#include <ContagionParameters.h>
#include <NetworkStructure.h>

using namespace std;

static const char *optString = "i:t:n:v:p:q:s:c:T:e:grh?";

typedef enum /* Declares an enumeration data type called BOOLEAN */ {
    FALSE, /* FALSE = 0, TRUE = 1 */
    TRUE
} BOOLEAN;

typedef struct {
    igraph_vector_t nodes;
    igraph_vector_t p_parameters;
    igraph_vector_t q_parameters;
    double step;
    long int no_of_iteration_per_cycle;
    long int no_of_cycles;
    double epsilon;
    char *input_file_name;
    char *file_type;
    BOOLEAN print_recovered;
    BOOLEAN using_giant;
	int temporal_threshold;
	igraph_vector_t T_parameters;
} input;


void init_infected_structure(input * input_args, infected_structure * p_infected_parameters);

void display_usage(void);

void read_input_arguments(int argc, char **argv, input * input_args);

void clear_input_arguments(input * input_args);

void parse_group_of_arguments(char *optarg, double step, const char *type, igraph_vector_t *values) ;

int string_to_translated_range(char* input_string, BOOLEAN is_integer, double step);

void read_benchmark_realization(igraph_vector_t * realization, int realization_id, char * filePath, int * source_id);

void read_realization_pqT( contagion_param_struct * epidemicParameters , int realization_id, char * filePath);

void load_geometric_distribution(double param, vector<double> *sample);

void load_B_distribution(int alpha, int betta, vector<double> * betta_distr_sample);

void set_epidemic_parameters(input * input_arg, contagion_param_struct * cont_param);

void load_stand_Norm_distribution(vector<double> *norm_distr_sample);

void multiply_distr_sigma(vector<double> * sample, double sigma);

#endif /* IMPORTS_H_ */
